<?php

namespace VM\AdminBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use VM\AdminBundle\Services\ApiGetter;
use VM\AdminBundle\Services\AuthCommunication;
use VM\AdminBundle\Services\SsoCommunication;
use VM\FinancialStatementsBundle\Services\AccountChanges\AccountChanges;

abstract class AbstractController extends Controller
{

    /**
     * @return ApiGetter
     */
    protected function getApiGetter()
    {
        return $this->get('vm_admin.api.getter');
    }


    /**
     * @return AuthCommunication
     */
    protected function getAuthCommunication()
    {
        return $this->get('vm_admin.auth.communication');
    }

    /**
     * @return SsoCommunication
     */
    protected function getSsoCommunication()
    {
        return $this->get('vm_admin.sso.communication');
    }

    /**
     * @return AccountChanges
     */
    protected function getAccountChanges()
    {
        return $this->get('vm_financial_account_changes');
    }

}
